public class StringUtil {
	final static int NCOL_DEF = 72;
	final static String DELIM_DEF = " \t\n\r\f-";

	public static void wrapln(String text, String delim, int ncol) {
		var token = new StringBuilder();
		var zeile = new StringBuilder();
		var stok = new java.util.StringTokenizer(text, delim, true);

		while (stok.hasMoreTokens()) {
			token.replace(0, token.length(), stok.nextToken());
			
			// Nach einem Zeilentrennzeichen wird der aktuelle Text ausgegeben und eine neue Zeile begonnen.
			if (isLineSep(token.charAt(0))) {
				write(zeile);
				zeile.delete(0, zeile.length());
				continue;
			}
			
			if (zeile.length() + token.length() <= ncol) {
				zeile.append(token);
			} else {
				write(zeile);
				while (token.length() > ncol) {
					zeile.replace(0, zeile.length(), token.substring(0, ncol));
					write(zeile);
					token.delete(0, ncol);
				}
				zeile.replace(0, zeile.length(), token.toString());
			}
		}
		write(zeile);
	}

	private static boolean isLineSep(char c) {
        return c == '\n' || c == '\r' || c == '\f';
	}
	
	private static void write(StringBuilder zeile) {
		while (zeile.length() > 0 && zeile.charAt(0) == ' ')
			zeile.deleteCharAt(0);
		if (zeile.length() > 0)
			IO.println(zeile);
	}

	public static void wrapln(String text, int ncol) {
		wrapln(text, DELIM_DEF, ncol);
	}

	public static void wrapln(String text) {
		wrapln(text, DELIM_DEF, NCOL_DEF);
	}	
}
